<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class OrderGuestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return  true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $userId = $this->route('user');
        return [
           'f_name' => 'required|string|max:255',
            'l_name' => 'required|string|max:255',
            'phone' => auth()->check() ? 'required|string|max:25': 'required|string|max:15',
            'email' => auth()->check() ? 'required|string|max:255': 'required|email|max:255',
            'country_id' => 'required|exists:countries,id' ,
            'region_id' => 'required|exists:regions,id',
            'area_id' => 'required|exists:areas,id',
            'address' => 'required|string|max:1000',
            'note' => 'nullable|string|max:1024',
            'address_id' => 'nullable|exists:addresses,id'
        ];
    }
}
