<?php

namespace App\Http\Requests;

use App\Models\ProductStock;
use Illuminate\Foundation\Http\FormRequest;

class CartItemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'product_stock_id' => 'required|exists:product_stock,id',
            'quantity'         => 'required|integer',
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            $productStockId = $this->input('product_stock_id');
            $quantity = $this->input('quantity');

            if ($productStockId) {
                $productStock = ProductStock::find($productStockId);
                if ($productStock && $quantity > $productStock->stock) {
                    $validator->errors()->add('quantity', 'The quantity cannot exceed the available stock.');
                }
            }
        });
    }

}
