<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BranchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
            'address_ar' => 'required|string|max:255',
            'address_en' => 'required|string|max:255',
            'map_url' => 'nullable|url',
            'status' => 'nullable|boolean',
            'order' => 'nullable|integer',
            'email' => 'nullable|email|max:255',
        ];
    }
}
