<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Hash;

class AccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return  true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
           'f_name' => 'required|string|max:255',
            'l_name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,' .$this->user()->id,
            'image' => 'nullable|image|max:2048', // Ensure valid image file
            'current_password' => [
                'required_with:password',
                function ($attribute, $value, $fail) {
                    if ($this->filled('password') && !Hash::check($value, $this->user()->password)) {
                        $fail(__('home.Current password doesn\'t match with old password.'));
                    }
                },
            ],
            'password' => 'nullable|string|min:8|confirmed',

        ];
    }
}
