<?php

namespace App\Http\Controllers\Website;

use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\AccountRequest;
use App\Http\Requests\AddressRequest;
use App\Http\Requests\WishlistRequest;
use App\Models\Address;
use App\Models\Area;
use App\Models\Country;
use App\Models\Order;
use App\Models\OrderStatus;
use App\Models\Region;
use App\Models\User;

class UserController extends Controller
{
    public function __construct(){
        $this->middleware('auth') ;
    }
    public function account(){
        $data['user'] = auth()->user();
        return view('website.user.account' , $data  ) ;
    }


    public function editAccount (){
        $data['user'] = auth()->user();
        return view('website.user.edit-account' , $data  ) ;
    }

    public function updateAccount(AccountRequest $request){
        $user = auth()->user();
        $userValidated = $request->validated();
         $userValidated['password'] = $request->password ? bcrypt($request->password) : null;
        if (empty($userValidated['password'])) {
            unset($userValidated['password']);
        }
        if($newImage = $request->file('image')){

            $image = new SaveImageTo3Path($newImage ) ;
            $imageName = $image->saveImages('users') ;
            SaveImageTo3Path::deleteImage($user->image ,'users') ;
            $userValidated['image'] =  $imageName ;
        }
        $user->update( $userValidated);
        return redirect()->back()->with('success',__('home.account information updated successfully')) ;
    }


    public function orders(){
        $data['orders'] = auth()->user()->orders;
        return view('website.user.orders' , $data  ) ;
    }


    public function orderDetails($order_number){
        $data['order'] = Order::with('products','status')->where('number',$order_number)->first();
        $data['all_status'] = OrderStatus::STATUS;
        return view('website.user.order-details' , $data  ) ;
    }

    public function addresses(){
        $data['addresses'] = auth()->user()->addresses ;
        $data['countries'] = Country::all();
        $data['regions'] = Region::byCountryAuth()->get();
        $data['areas'] = Area::byRegionAuth()->get();
        return view('website.user.addresses' , $data  ) ;
    }


    public function addAddress(AddressRequest $request){
        $addressValidated = $request->validated() ;
        $user = User::find(auth()->user()->id) ;
        if( $user->addresses()->create($addressValidated)){

           return redirect()->back()->with('success' , __('home.new address created successfully'));
        }
    }


    public function updateAddress(AddressRequest $request , $id){
        $address = Address::find($id);
        if (!$address) {
            return redirect()->back()->withErrors(__('home.no found')) ;
        }
        $addressValidated = $request->validated();
        $address->update( $addressValidated);
        return redirect()->back()->with('success',__('home.address updated successfully')) ;
    }

    public function deleteAddress($id){
        $address = address::find($id) ;
        if (!$address) {
            return redirect()->back()->withErrors(__('home.no found')) ;
        }
        if( $address->delete()){
            return redirect()->back()->with('success' , __('home.address deleted successfully'));
        }
        return redirect()->back() ;

    }



    public function store(WishlistRequest $request){
        $Item = $request->validated() ;
        $user = User::find(auth()->user()->id) ;
        if( $user->wishlistItems()->create($Item)){
            if(request()->ajax()){
                return response()->json(['message'=> __('home.your_item_added_successfully')]);
            }
           return redirect()->back()->with('success' , __('home.your_item_added_successfully'));
        }

        if(request()->ajax()){
            return response()->json(['message'=> __('home.an error occurred')],500);
        }
        return redirect()->back()->withErrors( __('home.an error occurred'));
    }

    //to get wish list count when store
    public function getCount(){
        $user = User::find(auth()->user()->id) ;
        if(request()->ajax()){
            return response()->json(['count'=> $user->wishlistItems->count()]);
        }
        return redirect()->back()->with('success' , $user->wishlistItems->count());
    }



    public function destroyItem( $stock_id){
        $user = User::find(auth()->user()->id) ;
        if($user->wishlistItems()->where('product_stock_id',$stock_id)->delete()){
           if(request()->ajax()){
            return response()->json(['message'=> __('home.your_item_deleted_successfully')]);
           }
           return redirect()->back()->with('message' , __('home.your_item_deleted_successfully'));
        }

        if(request()->ajax()){
            return response()->json(['message'=> __('home.an error occurred')]);
           }
           return redirect()->back()->withErrors( __('home.an error occurred'));
    }



}
