<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Http\Requests\SaleRequestRequest;
use App\Models\SaleRequest;
use App\Traits\SeoTrait;
use Exception;
use Illuminate\Http\Request;

class SaleRequestController extends Controller
{
    use SeoTrait;
    public function index(){

        list($data['schema'], $data['metatags']) = $this->contactUsPageSeo();

        return view('website.sale-requests.index' ,$data ) ;
    }


    public function store(SaleRequestRequest $request)
    {
       
        $data = $request->validated();
        SaleRequest::create($data );
        $message = __('home.Thank you for contacting us. A customer service officer will contact you soon');

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'contact_message' => $message,
            ]);
        }       

    }
}
