<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\AboutStruc;
use App\Models\Attribute;
use App\Models\Category;
use App\Models\Product;
use App\Models\Slider;
use App\Traits\SeoTrait;

class CategoryController extends Controller
{

    use SeoTrait;

    public function show($category_link)
    {
        $data['category'] = Category::active()->where('link_ar',$category_link)
        ->orWhere('link_en' ,$category_link)->first();
        if(!$data['category']){
            return abort(404);
        }
        $data['categoriesFilter'] = Category::active()->whereHas('products' )->get();
        $data['inStock'] = Product::active()->whereHas('category',function($q) use($category_link){
            $q->where('link_ar',$category_link)
            ->orWhere('link_en' ,$category_link);
        })->hasStock()->filterProduct()->whereHas('stocks', function($q){
            $q->where('stock', '>', 0);
        })->count();
        $data['outOfStock'] = Product::active()->whereHas('category',function($q) use($category_link){
            $q->where('link_ar',$category_link)
            ->orWhere('link_en' ,$category_link);
        })->hasStock()->filterProduct()->whereHas('stocks', function($q){
            $q->where('stock', '=', 0);
        })->count();
        $data['all'] = Product::active()->whereHas('category',function($q) use($category_link){
            $q->where('link_ar',$category_link)
            ->orWhere('link_en' ,$category_link);
        })->hasStock()->filterProduct()->count();
        $data['products'] = Product::active()->whereHas('category',function($q) use($category_link){
            $q->where('link_ar',$category_link)
            ->orWhere('link_en' ,$category_link);
        })->hasStock()->filterProduct()->paginate(50)->appends(request()->query());;
        list($data['schema'], $data['metatags']) = $this->productSPageSeo();

        return view('website.products.index',$data);
    }
    
    public function index()
    {
         $categories = Category::active();
         
        if($parent= request('parent')){
            $data['category']  = Category::active()->where('link_ar',$parent)
              ->orWhere('link_en' ,$parent)->first();
    
            $categories->where('parent_id',  $data['category']?->id);
      

        }else{
            $categories->mianCategory();
        }
        
        $categories = $categories->get();
        $data['categories'] = $categories ;
        list($data['schema'], $data['metatags']) = $this->categoriesPageSeo();

        return view('website.categories.index',$data);
    }

}
