<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Traits\SeoTrait;

class BlogController extends Controller
{

    use SeoTrait;

    public function index()
    {
        $data['blogs'] = Blog::active()->get();
        list($data['schema'], $data['metatags']) = $this->blogsPageSeo();
        return view('website.blogs.index',$data);
    }

    public function show($link)
    {
        $data['blog'] = Blog::where('link_ar' ,$link)->orWhere('link_en' ,$link)->first();
        if(!$data['blog']){
            return abort(404) ;
        }
        list($data['schema'], $data['metatags']) = $this->blogPageSeo($link);
        return view('website.blogs.show',$data);
    }


}
