<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Address;
use App\Models\Area;
use App\Models\Region;

class AddressController extends Controller
{


    public function index()
    {
        $data['addresses'] = Address::get();
        if(request()->ajax()){
            return response()->json( $data);
        }
        return redirect()->back();
    }

    public function getAreas()
    {
        $dataValidated = request()->validate([
            'region_id' => 'required|exists:regions,id'
        ]);
        $areas = Area::where('region_id',$dataValidated['region_id'])->get();
        $data['html'] = view('website.componants.area-select',['areas' => $areas])->render();
        if(request()->ajax()){
            return response()->json( $data);
        }
        return redirect()->back();
    }

    public function getRegions()
    {


        $dataValidated = request()->validate([
            'country_id' => 'required|exists:countries,id'
        ]);
        $regions = Region::where('country_id',$dataValidated['country_id'])->get();
        
        $data['html'] = view('website.componants.region-select',['regions' => $regions])->render();

        if(request()->ajax()){
            return response()->json( $data);
        }
        return redirect()->back();
    }



}
