<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use App\Models\Brand;
use App\Models\Page;
use App\Models\Blog;
use DB;

class SiteMapController extends Controller
{

    public function indexSitemap(){
        return response()->view('sitemap.index')->header('Content-Type', 'text/xml');
    }

    public function allProductSitemap(){
        $products= Product::where('status',1)->latest()->get();
        return response()->view('sitemap.all-products-sitemap', [
    	      'products'=>$products,
    	])->header('Content-Type', 'text/xml');
    }

    public function categoriesSitemap(){
        $categories = Category::where('status',1)->latest()->get();
        return response()->view('sitemap.categories-sitemap', [
    	      'categories' => $categories,
    	])->header('Content-Type', 'text/xml');
    }

    public function pagesSitemap(){
        $pages = Page::latest()->get();
        return response()->view('sitemap.pages-sitemap', [
    	      'pages' => $pages,
    	])->header('Content-Type', 'text/xml');
    }

    public function blogsSitemap(){
        $blogs = Blog::latest()->get();
        return response()->view('sitemap.blogs-sitemap', [
    	      'blogs' => $blogs,
    	])->header('Content-Type', 'text/xml');
    }

    public function brandsSitemap (){
        $brands= Brand::latest()->where('status',1)->get();
        return response()->view('sitemap.brands-sitemap', [
    	      'brands' => $brands,
    	])->header('Content-Type', 'text/xml');
    }

    public function productOffersSitemap(){
        $products = Product::active()->hasStock()->hasDiscount()->get();
        return response()->view('sitemap.productOffers-sitemap', [
    	      'products'=>$products,
    	])->header('Content-Type', 'text/xml');
    }

    // public function trendingProductSitemap(){
    //     $products= Product::where('featurd',1)->where('status',1)->latest()->get();
    //     return response()->view('sitemap.all-products-sitemap', [
    // 	      'products'=>$products,
    // 	])->header('Content-Type', 'text/xml');
    // }




}
