<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Illuminate\Http\Request;
use Laravel\Socialite\Facades\Socialite;
use App\Models\User;

use Illuminate\Support\Str;

use App\Models\GuestCart;
use App\Models\GuestCartProduct;

use App\Models\Cart;
use App\Models\CartProduct;
use App\Traits\Carts\ConvertFromCartGuestToCartTraite;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers ,ConvertFromCartGuestToCartTraite;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/order-checkOut';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // session(['url.intended' => url()->previous()]);
        // $this->redirectTo = session()->get('url.intended');

        $this->middleware('guest')->except('logout');
        // $this->middleware('guest:vendor')->except('logout');
    }

    use AuthenticatesUsers {
        logout as performLogout;
    }

    public function logout(Request $request){
        $this->performLogout($request);
        return redirect('/');
    }

    public function redirectToFacebookProvider(){
        return Socialite::driver('facebook ')->redirect();
    }

    public function handleFacebookProviderCallback(Request $request){
        try {
            $user = Socialite::driver('facebook')->user();

            $saveUser = User::updateOrCreate([
                'facebook_id' => $user->getId(),
            ],[
                'name' => $user->getName(),
                'email' => $user->getEmail(),
                'password' => Hash::make($user->getName().'@'.$user->getId())
                 ]);

            Auth::loginUsingId($saveUser->id);

            return redirect()->route('home');
            } catch (\Throwable $th) {
               throw $th;
            }
    }

    public function redirectToGoogleProvider(){
        return Socialite::driver('google')->redirect();
    }

    public function handleGoogleProviderCallback(){
        try{
        $googleUser = Socialite::driver('google')->stateless()->user();
        $user = User::where('email', $googleUser->email)->first();
        if(!$user)
        {
            $user = User::create(['name' => $googleUser->name, 'email' => $googleUser->email, 'password' => Hash::make(rand(100000,999999))]);
        }

        Auth::login($user);
        $this->guestOperations();
        return redirect(RouteServiceProvider::HOME);

        } catch (Exception $e) {
            return redirect ('/');
        }
    }

    public function showLoginForm(){
        if(!session()->has('url.intended')){
            session(['url.intended' => url()->previous()]);
        }
        // $gallery_image = GalleryImage::first();
        return view('auth.login');
    }

    public function login(Request $request){
        $this->validateLogin($request);
        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if ($this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);
            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {

            //// add guest cart and wishlist///
            // $this->guestOperations();
            $user = Auth::user();
            $this->guestOperations();
            if ($user->roles->isEmpty()) {
                return redirect('/');  // If user has no roles assigned, => 'users'

            }elseif($user->roles->where('name','vendor')->first()){
                return redirect('/admin/products');
            }else{
                return redirect('/admin'); // If user has roles assigned, => 'admin or anything else'
            }
            // return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

}
