<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\SliderRequest;
use App\Models\Slider;
use Exception;

class SliderController extends Controller
{


    public function __construct(){
        $this->middleware(['permission:sliders']);
    }

    public function index()
    {
        //
        $data['sliders'] = Slider::orderBy('order')->whereType('home')->get();
        return view('admin.sliders.sliders', $data);
    }


    public function create()
    {
        return view('admin.sliders.addSlider');
    }


    public function store(SliderRequest $request)
    {
        $data = $request->validated();
        if ($request->hasFile("image")) {
            $file = $request->file("image");
            $saveImage = new SaveImageTo3Path($file,true);
            $fileName = $saveImage->saveImages('sliders');
            $data['image'] = $fileName;
        }

        Slider::create($data);
        return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
    }




    public function edit($id)
    {
        $slider = Slider::find($id);
        if($slider){
            return view('admin.sliders.editSlider',compact('slider'));
        }else{
            abort('404');
        }
    }


    public function update(SliderRequest $request, $id)
    {
        $slider = Slider::find($id);
        $data = $request->validated();
        if ($request->hasFile("image")) {
            $file = $request->file("image");
            $saveImage = new SaveImageTo3Path($file,true);
            $fileName = $saveImage->saveImages('sliders');
            SaveImageTo3Path::deleteImage(  $slider->image, 'sliders');
            $data['image'] = $fileName;
        }
        $slider->update($data);
        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:sliders,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Slider::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($slider = Slider::find($id)){
                $slider->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json(Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }

}
