<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ShippingFeesRequest;
use App\Models\Area;
use App\Models\Country;
use App\Models\Region;
use App\Models\ShippingFees;


class ShippingFeesController extends Controller
{

    public function __construct(){
        $this->middleware(['permission:shippingFees']);
    }

    public function index()
    {
        $shippingFees = ShippingFees::query();
        if(request('area_id')){
            $shippingFees->where('area_id' , request('area_id'));
        }

        if(request('region_id')){
            $shippingFees->whereHas('area' , function($q){
                $q->where('region_id' , request('region_id'));
            });
        }

        if(request('country_id')){
            $shippingFees->whereHas('area' , function($q){
                $q->whereHas('region' , function($q){
                    $q->where('country_id' , request('country_id'));
                });
            });
        }

        $data['shippingFeeses'] = $shippingFees->get();
        $data['countries'] = Country::get();
        $data['regions'] = Region::get();
        return view('admin.shippingFees.index',$data);
    }

    public function update(ShippingFeesRequest $request)
    {

        $data = $request->validated() ;
        foreach ($data['ids'] as $index =>  $id) {
            $area_fees = ShippingFees::find($id);
            $area_fees->update(['fees' => $data['feeses'][$index]]);
        }

        if(request()->ajax()){
            return response()->json(['message' => trans('home.your_item_updated_successfully')]);
        }
        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }

    public function addNewArea(){
        $areaIds = ShippingFees::pluck('area_id')->toArray(); // Get area IDs from ShippingFees
        $missingAreas = Area::whereNotIn('id', $areaIds)->pluck('id')->toArray(); // Get missing area IDs
        // Prepare data for batch insertion
        $insertData = array_map(fn($id) => ['area_id' => $id], $missingAreas);
        ShippingFees::insert($insertData); // Batch insert missing areas
        return redirect()->back()->withErrors(__("home.your_item_added_successfully")) ;
    }

}
