<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\ImageRequest;
use App\Http\Requests\ServiceRequest;
use App\Models\Service;
use App\Traits\ImagesTrait;
use Exception;

class ServiceController extends Controller
{

    use ImagesTrait ;
    public function __construct(){
        $this->middleware(['permission:services']);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $services = Service::orderBy('id','DESC')->get();
        return view('admin.services.index',compact('services'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $services = Service::where('status',1)->get();
        return view('admin.services.create',compact('services'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ServiceRequest $request)
    {
        $data = $request->validated() ;

        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'),true);
            $fileName = $saveImage->saveImages('services');
            $data['image'] = $fileName ;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'),true);
            $fileName = $saveImage->saveImages('services');
            $data['icon'] = $fileName ;
        }

        Service::create($data) ;

        return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit( $id)
    {
        $service = Service::findOrFail($id);
        $services = Service::where('id','!=',$id)->where('status',1)->get();
        return view('admin.services.edit',compact('services','service'));

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ServiceRequest $request, $id)
    {
        $service = Service::findOrFail($id) ;
        $data = $request->validated() ;
        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'),true);
            $fileName = $saveImage->saveImages('services');
            SaveImageTo3Path::deleteImage($service->image,'services');
            $data['image'] = $fileName;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'),true);
            $fileName = $saveImage->saveImages('services');
            SaveImageTo3Path::deleteImage($service->icon,'services');
            $data['icon'] = $fileName;
        }
        $service->update($data) ;

        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( $id)
    {
        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:services,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Service::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($service = Service::findOrFail($id)){
                $service->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }
    }

    public function getImages($id){
        $service = Service::with('images')->find($id) ;
        if( $service){
           $data['parent'] = $service ;
           $data['remove_url'] = route('services.images.remove',$service->id) ;
           $data['upload_url'] = route('services.images.upload',$service->id) ;

           return view('admin.services.images.index',$data);

        }

    }

    public function uploadImages(ImageRequest $request,$id){
        $service = Service::find($id) ;
        if( $service){
            $response =  $this->saveImages($request, $service) ;
            return $response
            ? redirect()->back()->with( 'success',__('home.your_items_added_successfully'))
            : redirect()->back()->withErrors($response);
        }
        return redirect()->back()->withErrors(__('home.not_found'));
    }
}
