<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\SaleRequest;
use Exception;
use Illuminate\Http\Request;

class SaleRequestController extends Controller
{
    public function index()
    {
        $data['sale_requests'] = SaleRequest::latest()->get();
        return view('admin.sale_requests.index', $data);
    }

        public function show(SaleRequest $saleRequest)
    {
        if(!$saleRequest){
            abort('404');
        }
        if(!$saleRequest->is_read){
            $saleRequest->is_read = 1;
            $saleRequest->save();
        }
        return view('admin.sale_requests.show',compact('saleRequest'));
    }

    public function destroy( $id)
    {
        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:sale_requests,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                SaleRequest::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($saleRequest = SaleRequest::findOrFail($id)){
                $saleRequest->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }
    }
}
