<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{

    public function index()
    {
        //
        $roles = Role::all();
        return view('admin.roles.roles',compact('roles'));
    }


    public function create()
    {
        $permissions= Permission::all();
        return view('admin.roles.addRole',compact('permissions'));
    }


    public function store(Request $request)
    {
        $role = Role::create(['name' => $request->name]);
        $role->syncPermissions($request->permissions);
        return redirect('admin/roles');
    }


    public function edit($id)
    {
        //
        $role = Role::find($id);
        $allPermissions= Permission::all();
        $rolePermissions= $role->permissions()->pluck('name')->toArray();
        return view('admin.roles.editRole',compact('role','allPermissions','rolePermissions'));
    }


    public function update(Request $request, $id)
    {
        //
        $role = Role::find($id);
        $role->name= $request->name;
        $role->save();

        $rolePermissions= $role->permissions()->get();
        foreach($rolePermissions as $rolePermission){
            $role->revokePermissionTo($rolePermission);
        }

        $role->syncPermissions($request->permissions);
        return redirect('admin/roles');
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:roles,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Role::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($role = Role::find($id)){
                $role->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json(Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}
