<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{

    public function index()
    {

        $permissions= Permission::all();
        return view('admin.permissions.permissions',compact('permissions'));
    }

    public function create()
    {
        //
        return view('admin.permissions.addPermission');
    }

    public function store(Request $request)
    {
        //
        $permission = Permission::create(['name' => $request->name]);
        return redirect('admin/permissions');

    }



    public function edit($id)
    {
        //
        $permission=Permission::find($id);
        return view('admin.permissions.editPermission',compact('permission'));
    }


    public function update(Request $request, $id)
    {
        //
        $permission = Permission::find($id);
        $permission->name = $request->name;
        $permission->save();
        return redirect('admin/permissions');
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:permissions,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Permission::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($permission = Permission::find($id)){
                $permission->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}
