<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderProduct;
use App\Models\OrderStatus;
use App\Models\WishlistPaid;
use App\Models\Invoice;
use App\Models\Delivery;
use Illuminate\Http\Request;

use App\Traits\SMSTrait;
use Carbon\Carbon;
use Exception;

class OrderController extends Controller
{

    use SMSTrait;


    public function __construct(){
        $this->middleware(['permission:orders']);
    }

    public function index()
    {
        $orders = Order::with(['user','address'])->orderBy('id','desc')->adminFilter()->get();
        return view('admin.orders.orders',compact('orders'));
    }


    public function edit($id)
    {
        $data['order'] = Order::with(['products','orderStatus','status'])->find($id);
        if($data['order']){
            $data['order']->update(['admin_seen',1]);
            $data['nextActions'] =array_values(array_diff(OrderStatus::STATUS,$data['order']->orderStatus->pluck('status')->toArray()));
            $data['deliveries'] = Delivery::where('status','active')->get();
            $data['order']->update(['admin_seen' => 1]) ;
            $data['order']->refresh() ;
            return view('admin.orders.editOrder',$data);
        }else{
            abort('404');
        }
    }

    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:orders,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Order::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($order = Order::find($id)){
                $order->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
    public function changeOrderStatus(){
        $orderId = request('orderId');
        $status =request('status');
        $note =request('note')??'';
        $order = Order::find($orderId);
        if($order->status == 'delivered'){
            return redirect()->back()->withError(__('home.cannot change an order status that is delivered'));
        }



        if($status == 'canceled' && !$note ){

            return redirect()->back()->withError(__('home.you should write the reason for cancellation'));
        }

        if($status == 'accept' && !$note && $order->status == 'canceled'){
            return redirect()->back()->withError(__('home.you should write the reason for acceptance if the order is canceled later'));
        }
        if($status == 'shipping' && !$order->delivery_id){
            return redirect()->back()->withError(__('home.you need to assign a delivery person before the order can be shipped'));
        }

        if($status == 'delivered'){
            $order->payment_status = 'paid';
            $order->save();
        }


        $orderStatus = new OrderStatus();
        $orderStatus ->order_id = $orderId;
        $orderStatus ->status = $status;
        $orderStatus ->note = $note;
        $orderStatus->save();
        if(!request()->ajax()){
           return redirect()->back()->with('success' ,__('home.order canceled succesfully')) ;
        }

    }


    public function pushNotification($token , $title, $body){
        define( 'API_ACCESS_KEY', 'AAAAouF7Fp0:APA91bFgti4nu6h58keC_XZfyW0HlrQoJROK0qDSGsUyAN5U5oCbR1EiX5nSjvU9mjOh85y3k3be0UOBIphoGnL3z9vS7OIP5a6CIo9QNroai0u8VVUKydQ51IjHfuPVzhYCDcxuax92' );

        $fcmUrl = 'httpsfcm.googleapis.comfcmsend';

        $notification = [
            'title' => $title,
            'body' => $body,
            'icon' => 'myIcon',
            'sound' => 'mySound'
        ];
        $extraNotificationData = ['message' => $notification,'moredata' =>'dd'];

        $fcmNotification = [
            //'registration_ids' => $tokenList, //multple token array
            'to'=> $token, //single token
            'notification' => $notification,
            'data' => $extraNotificationData
        ];

        $headers = [
            'Authorization key=' . API_ACCESS_KEY,
            'Content-Type applicationjson'
        ];


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$fcmUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
        $result = curl_exec($ch);
        curl_close($ch);
    }

    /////////// function view order invioce////////////
    public function orderInvoice($id){

        $orderId = $id;
        $order = Order::with('products')->find($id);
        if($order){
            return view('admin.orders.invoice',compact('order'));
        }else{
            return redirect('admin/orders')->withErrors(__('home.not found'));
        }

    }

    //////////// function order filter ////////////
    public function orderFilter(){
        $orderNumber = request('order_number');
        $status = request('status');
        $dateFrom = request('dateFrom');
        $dateTo = request('dateTo');
        if($orderNumber){

            $orders = Order::where('status',$status)->get();

        }else{
            $orders = Order::query();
            if($dateFrom){

                $from = Carbon::parse($dateFrom)->startOfDay();
                $orders = $orders->where('created_at', '>=',$from);
            }
            if($dateTo){

                $to = Carbon::parse($dateTo)->startOfDay();
                $orders = $orders->where('created_at', '<=',$to);
            }

            if($status){
                $orders->where('status',$status);
            }

            $orders = $orders->get();

        }


        if(request()->ajax()){
            return response()->json([
                'html' => view('admin.orders.orderFilterResult', compact('orders'))->render(),
            ]);
        }else{
            return view('admin.orders.orders',compact('orders'));
        }
    }

    public function OrderDelivey(Request $request,$id){
        $order = Order::find($id);
        $order->delivery_id = $request->delivery_id;
        $order->save();
        return back()->with('success',trans('home.delivery time added successfully'));
    }


    public function orderCancel($id){
        $orderId = request('orderId');
        $orderId = request('not');
        $order = Order::find($orderId);

        if($order->status == 'delivered'){
            return redirect()->back()->withError(__('home.cannot change an order status that is delivered'));
        }



        $orderStatus = new OrderStatus();
        $orderStatus ->order_id = $orderId;
        $orderStatus ->status = 'canceled';
        $orderStatus->save();

        return back()->with('success',trans('home.order canceled succesfully'));
    }

}
