<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\CouponRequest;
use App\Models\Coupon;
use Exception;

class CouponController extends Controller
{

    public function index()
    {
        $coupons = Coupon::get();
        return view('admin.coupons.coupons',compact('coupons'));
    }


    public function create()
    {
        return view('admin.coupons.addCoupon');
    }

    public function store(CouponRequest $request)
    {
        $data = $request->validated();
        Coupon::create($data);
        return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
    }


    public function edit($id)
    {
        $data['coupon'] = Coupon::find($id);
        return view('admin.coupons.editCoupon' , $data);
    }
    public function update(CouponRequest $request, $id)
    {

        $add = Coupon::find($id);
        $data = $request->validated();
        $add->update($data);
        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                $ids =  request('id') ;
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:coupons,id'
                ]);
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Coupon::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($coupon = Coupon::find($id)){
                $coupon->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }



}
