<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\CountryRequest;
use App\Models\Country;
use Exception;


class CountryController extends Controller
{


    public function __construct(){
        $this->middleware(['permission:countries']);
    }

    public function index()
    {
        //
        $countries = Country::orderBy('id','DESC')->get();
        return view('admin.countries.countries',compact('countries'));
    }


    public function create()
    {
        //
        return view('admin.countries.addCountry');
    }


    public function store(CountryRequest $request)
    {
        $data = $request->validated() ;
        if(Country::create($data)){
            return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
        }
        return redirect()->back()->withErrors(trans('home.an error has occurred. Please contact the developer to resolve the issue'));
    }



    public function edit($id)
    {
        $country = Country::find($id);
        return view('admin.countries.editCountry',compact('country'));
    }


    public function update(CountryRequest $request, $id)
    {

        $country = Country::find($id);
        $data = $request->validated() ;
        if($country->update($data)){
            return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
        }
        return redirect()->back()->withErrors(trans('home.an home.an error has occurred. Please contact the developer to resolve the issue'));

    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:Countries,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Country::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($country = Country::find($id)){
                $country->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}
