<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\CategoryRequest;
use App\Models\Category;
use Exception;
use Illuminate\Http\Request;
use App\Exports\CategoryExport;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\CategoryImport;


class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:categories']);
    }

    public function index()
    {
        //
        $categories = Category::orderBy('id','DESC')->get();
        return view('admin.categories.categories',compact('categories'));
    }


    public function create()
    {
        $categories=Category::where('status',1)->get();
        return view('admin.categories.addCategory',compact('categories'));
    }


    public function store(CategoryRequest $request)
    {
        $data = $request->validated() ;

        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'),true);
            $fileName = $saveImage->saveImages('categories');
            $data['image'] = $fileName ;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'),true);
            $fileName = $saveImage->saveImages('categories');
            $data['icon'] = $fileName ;
        }

        Category::create($data) ;

        return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
    }


    public function edit($id)
    {
        $category = Category::find($id);
        if($category){
            $categories = Category::where('id','!=',$id)->where('status',1)->get();
            return view('admin.categories.editCategory',compact('categories','category'));
        }else{
            abort('404');
        }

    }


    public function update(CategoryRequest $request, $id)
    {
        $category = Category::find($id) ;
        $data = $request->validated() ;
        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'),true);
            $fileName = $saveImage->saveImages('categories');
            SaveImageTo3Path::deleteImage($category->image,'categories');
            $data['image'] = $fileName;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'),true);
            $fileName = $saveImage->saveImages('categories');
            SaveImageTo3Path::deleteImage($category->icon,'categories');
            $data['icon'] = $fileName;
        }
        $category->update($data) ;

        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:categories,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Category::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($category = Category::find($id)){
                $category->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }


    public function export()
    {
        return Excel::download(new CategoryExport, 'category.xlsx');
    }

    public function import(Request $request)
    {

        $request->validate([
            'excel' => 'required|mimes:xlsx,csv,xls'
        ]);
        Excel::import(new CategoryImport, $request->file('excel'));

        return back()->with('success', 'Excel data imported successfully!');
    }

}
