<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\BlogRequest;
use App\Models\Blog;
use Exception;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:blogs']);
    }

    public function index()
    {
        //
        $blogs = Blog::orderBy('id','DESC')->get();
        return view('admin.blogs.index',compact('blogs'));
    }


    public function create()
    {
        $blogs=Blog::where('status',1)->get();
        return view('admin.blogs.create',compact('blogs'));
    }


    public function store(BlogRequest $request)
    {
        $data = $request->validated() ;

        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'),true);
            $fileName = $saveImage->saveImages('blogs');
            $data['image'] = $fileName ;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'),true);
            $fileName = $saveImage->saveImages('blogs');
            $data['icon'] = $fileName ;
        }

        Blog::create($data) ;

        return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
    }


    public function edit($id)
    {
        $blog = Blog::find($id);
        if($blog){
            $blogs = Blog::where('id','!=',$id)->where('status',1)->get();
            return view('admin.blogs.edit',compact('blogs','blog'));
        }else{
            abort('404');
        }

    }


    public function update(BlogRequest $request, $id)
    {
        $blog = Blog::find($id) ;
        $data = $request->validated() ;
        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'),true);
            $fileName = $saveImage->saveImages('blogs');
            SaveImageTo3Path::deleteImage($blog->image,'blogs');
            $data['image'] = $fileName;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'),true);
            $fileName = $saveImage->saveImages('blogs');
            SaveImageTo3Path::deleteImage($blog->icon,'blogs');
            $data['icon'] = $fileName;
        }
        $blog->update($data) ;

        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:blogs,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Blog::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($blog = Blog::find($id)){
                $blog->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }

}
