<?php

namespace App\Helpers;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class Helper
{


    public static $lang;

    // Static initializer
    public static function init()
    {
        self::$lang = LaravelLocalization::getCurrentLocale();
    }


    public static function noImage()
    {
        return url('uploads/noimage.png');
    }

    public static function noImageUser()
    {
        return url('uploads/user.png');
    }

    public static function videoImage()
    {
        return url('uploads/videoimage.png');
    }
    public static function getLang(): string
    {
        if (self::$lang === null) {
            self::$lang = LaravelLocalization::getCurrentLocale();
        }
        return self::$lang;
    }

    public static function frontFilesPath(string $string){
        return url('public/assets/front/'.$string);
    }
    public static function cssFilesPath(string $string){
        return url('public/assets/front/css/'.$string);
    }
    public static function pluginsFilesPath(string $string){
        return url('public/assets/front/plugins/'.$string);
    }

    public static function fontsFilesPath(string $string){
        return url('public/assets/front/fonts/'.$string);
    }

    public static function jsFilesPath(string $string){
        return url('public/assets/front/js/'.$string);
    }

    public static function imageFilesPath(string $string){
        return url('public/assets/front/images/'.$string);
    }

    public static function uploadedImagesPath($model,$image){
        return url('uploads/'.$model.'/source/'.$image);
    }

    public static function uploadedImages200Path($model,$image){
        return url('uploads/'.$model.'/resize200/'.$image);
    }


    public static function uploadedSliderImagesPath($model,$image){
        return url('uploads/sliders/'.$model.'/source/'.$image);
    }



    public static function removeTags(string | null $text): string
    {
        return html_entity_decode(strip_tags($text));
    }


    public static function cutText(string | null $text, int $length, string $after = ' '): string
    {
        if ($length <= 0 || $length >= mb_strlen($text)) {
            return $text;
        }

        $specialCharPos = mb_strpos($text, $after, $length);

        if ($specialCharPos !== false) {
            return mb_substr($text, 0, $specialCharPos + 1);
        }

        return mb_substr($text, 0, $length);
    }


    public static function removeTagsAndCutText(string | null $text, int $length , string $after = ' '): string
    {
        $cleanText = self::removeTags($text);
        // If $number is specified, cut after the first space or special character
        if ($length > 0) {
            return self::cutText($cleanText, $length, $after);
        }

        return $cleanText;
    }

    public static function imageIsExists(string|null $image , string $folder ):bool{
        $path = base_path("uploads/$folder/source/$image");
        return $image && file_exists( $path );
    }

    public static function ifNotInWishlist( $stock_id):bool{
        return auth()->check() && !User::find(auth()->user()->id)?->stockInWishlist($stock_id) ;
    }

    public static function userCanRate($product_id):bool{
        return auth()->check() && User::find(auth()->user()->id)?->canRate($product_id) ;
    }

    public static function handleDate($date): string
    {
        $carbonDate = Carbon::parse($date); // Parse the input date
        $now = Carbon::now(); // Current time

        if ($carbonDate->isSameMinute($now)) {
            // If the date is the same minute
            return __('home.now');
        }

        $diffInMinutes = $now->diffInMinutes($carbonDate);

        if ($diffInMinutes < 60) {
            // If within the last hour
            return __('home.from') . ' ' . $diffInMinutes . ' ' . trans_choice('home.minutes', $diffInMinutes);
        }

        $diffInHours = $now->diffInHours($carbonDate);

        if ($diffInHours < 24 && $carbonDate->isToday()) {
            // If within today
            return __('home.from') . ' ' . $diffInHours . ' ' . trans_choice('home.hour', $diffInHours);
        }

        if ($carbonDate->isYesterday()) {
            // If the date is yesterday
            return __('home.yesterday');
        }

        if ($carbonDate->isSameYear()) {
            return $carbonDate->format('M d');
        }

        // For older dates, return the formatted date
        return $carbonDate->format('Y M d');
    }


    public static function SendEmail( $to , $message ,  $title){
        Mail::raw($message, function ($emailMessage ) use($title , $to){
            $emailMessage->to($to)->subject($title);
        });
        return true ;
    }

    public static function checkShippingFree( $total , $shipping_fees ){
        if(config('site_shipping_free_in_status')){
            return $total > config('site_shipping_free_in_amount') ? $total : $total + $shipping_fees ;
        }
        return $total + $shipping_fees ;
    }

    public static function  messageError(string | Collection | array $errors){
        if (!$errors instanceof Collection) {
            $errors = collect($errors);
        }
        $validator = Validator::make([], []); // Create an empty validator instance

        foreach ($errors as $error) {
            $validator->errors()->add('error', $error); // Add errors
        }
        if(!request()->ajax()){
            session()->flash('errors',   $validator->errors());
        }

        return $validator ;
    }

}
