<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan; // Add this import
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Exception;

class ProcessQueue extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'queue:process-jobs';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process queue jobs';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            // First check if there are any failed jobs
            $failedJobsCount = DB::table('failed_jobs')->count();
            
            if ($failedJobsCount > 0) {
                Log::info("Attempting to retry {$failedJobsCount} failed jobs");
                
                // Retry all failed jobs
                Artisan::call('queue:retry', ['id' => ['all']]);
                Log::info("Successfully retried {$failedJobsCount} jobs");
            } else {
                Log::info("No failed jobs to retry");
            }
        
            // Process the queue
            Log::info("Starting queue worker with 5 minute timeout");
            Artisan::call('queue:work', [
                '--queue' => 'default', // Specify your queue name
                '--stop-when-empty' => true,
                '--max-time' => 300, // 5 minutes
                '--timeout' => 120, // Job timeout (seconds)
                '--tries' => 3 // Number of retry attempts
            ]);
            
            Log::info("Queue worker completed processing");
        
        } catch (Exception $e) {
            Log::error("Queue processing failed: " . $e->getMessage());
            // Consider adding notification here (email, slack, etc.)
        }
    
        
    }
}
